#ifndef EXCEPT_H
#define EXCEPT_H

/************************************************************************
 ** COPYRIGHT (C) 2008 by: Gregory Stern   All Rights Reserved.
 ************************************************************************/

#include "sdefines.h"
#include "WtptpDownLoad.h"

class CExcept
{
	eProcessStatus m_eProcStatus;
	eProcessState m_eProcState;

	UINT m_nResourceID;
	CString m_ErrMsg;
public:

    //CExcept(UINT nResourceID);
	CExcept(UINT nResourceID, ...);
	CExcept(LPCTSTR lpErrMsg):m_ErrMsg(lpErrMsg){};
	CExcept(eProcessStatus eProcStatus, LPCTSTR msg = _T(""));
	CExcept::CExcept(eProcessState eProcState, LPCTSTR lpErrMsg = _T(""));
	//CExcept(eProcessState eProcState, eProcessStatus eProcStatus);
	CExcept(eProcessState eProcState, eProcessStatus eProcStatus, LPCTSTR msg);
	CExcept(UINT nResourceID, eProcessState eProcState, eProcessStatus eProcStatus);
	CExcept(LPCTSTR msg, eProcessState eProcState, eProcessStatus eProcStatus);
	CExcept(eProcessState eProcState, eProcessStatus eProcStatus, UINT nResourceID, ... );
	CExcept(eProcessState eProcState, eProcessStatus eProcStatus, int = 0, ... );
	CExcept(LPCTSTR msg, eProcessState eProcState, eProcessStatus eProcStatus, LPCTSTR lpErrMsg);


    ~CExcept(){};

	void  FormatMsg(int idx, ...);
    const char *ShowReason() const { return m_ErrMsg; }
	const eProcessState GetState() const { return m_eProcState; }
	const eProcessStatus GetStatus() const { return m_eProcStatus; }

private:

	void FormatMsg(LPCTSTR RawMsg, ...);
};


#endif //EXCEPT_H