// IFLSWD_SampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "IFLSWD_Sample.h"
#include "IFLSWD_SampleDlg.h"
#include "..\WtptpDownLoad\WtptpDownLoad.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DEVICE_USB_PORT            _T("USB Port")
#define WM_CALLBACK	               WM_USER+1
#define IFLSWDDLL_NAME            _T("IFL_SWD.dll")
#define WTPTPDOWNLOADDLL_NAME     _T("WtptpDownLoad.dll")


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

void CALLBACK CallbackProc(LPVOID pParam, WPARAM wParam, LPARAM lParam);

typedef bool (* READBLF)(PInstanceParams pInstParam,const TCHAR * pszBLFfileName);
typedef bool (* FREEINSTANCEPARAMS)(PInstanceParams pInstParam);
typedef PInstanceParams (*MALLOCINSTANCEPARAMS)();
typedef PInstanceParams (* PREPAREDOWNLOADWITHFBF)(PInstanceParams pInstParam,const TCHAR * pszBLFfileName ,const TCHAR* pszFlasherfileName,const TCHAR *pszFBFfileName);
typedef bool (* PREPAREUPLOAD)(PInstanceParams pInstParam,const TCHAR * pszUploadCfgfileName);
typedef BOOL (* INITIALIZEBL)(PInstanceParams pInstParam);
typedef BOOL (* TERMINATEBL)();
typedef bool (* DOWNLOADWPACKAGE)(const TCHAR* pszDownloadPackagePath,PInstanceParams pInstParam);
typedef bool (* MAKEDOWNLOADPACKAGE)(const TCHAR* pszBlfFileName, const TCHAR* pszDownloadPackageName);
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIFLSWD_SampleDlg dialog

void CALLBACK CallbackProc(LPVOID pParam, WPARAM wParam, LPARAM lParam)
{
	CWnd* pWnd = (CWnd*)pParam;
	if(pWnd == NULL)
		return;

	NotifyStatus* pNtStat = new NotifyStatus; 
	*pNtStat = *(NotifyStatus*)lParam;
	pWnd->PostMessage(WM_CALLBACK, wParam, (LPARAM)pNtStat);
}
LRESULT CIFLSWD_SampleDlg::OnCallbackFunc(WPARAM wParam, LPARAM lParam)
{	
	NotifyStatus* l_pNotifyStatus = (NotifyStatus*)lParam;

	CString strState, strStatus;

    SetProcState(l_pNotifyStatus);
   
	switch(l_pNotifyStatus->eProcState)
	{
		
		case kProcConnecting:
			 AddDevice((NotifyStatus*)lParam);
			 break;	 
		case kProcDownloading:
			{
				 OnProgressToView((LPARAM)l_pNotifyStatus);
				 if ( _tcscmp(l_pNotifyStatus->lpProcMsg, _T("BadBlkNum") ) == 0 )
					 TRACE2("Downloading, Devices: TotalBadBlocks = %d, Total Blocks = %d\n", 
					 l_pNotifyStatus->lpBadBlk.TotalBadBlocks,  l_pNotifyStatus->lpBadBlk.TotalBlocks);
				 //To do your code, you can abort the download at certain bad blocks number.
				 if(((l_pNotifyStatus->lpBadBlk.TotalBadBlocks)*50) > l_pNotifyStatus->lpBadBlk.TotalBlocks)
				 {
					OnButtonTerminateDownload();
					return -1;
				  }
			 }
             break;
		case kProcUsbRemove: 
	         // To do your code
			 break;
		case kProcBurningFlash:
			{
				OnProgressToView((LPARAM)l_pNotifyStatus);
				if ( _tcscmp(l_pNotifyStatus->lpProcMsg, _T("CRCS") ) == 0 )
				{
					TRACE2("Burning, Devices: MCPID: 0x%x, ImageNum: %d\n", 
						l_pNotifyStatus->lpImageCrc.MCPID,  l_pNotifyStatus->lpImageCrc.ImageNum);
					for(UINT32 i = 0; i < l_pNotifyStatus->lpImageCrc.ImageNum; i++)
						TRACE2("ImageID: 0x%x, CrcData: 0x%08X\n", 
						l_pNotifyStatus->lpImageCrc.ImageCRC[i].ImageID,  l_pNotifyStatus->lpImageCrc.ImageCRC[i].CRC32);
					
					//To do your code, you can save the image Crc as you will
				}
			 }
			 break;
		case kProcAborting:
			// To do your code Download failed
			break;
		case kProcCompleted:
			OnProgressToView((LPARAM)l_pNotifyStatus);
			if (eUpload == m_DLType)
			{
				PostMessage(WM_COMMAND, MAKEWPARAM(IDC_BUTTON_TERMINATE, BN_CLICKED), NULL);
			}
			break;
		case kProcUploadingData:
			OnProgressToView((LPARAM)l_pNotifyStatus);
			break;
		case kProcDebugLog:
			{
				//To do your code
				CString strtmp;
				strtmp = l_pNotifyStatus->lpProcMsg;
				//user can output pNtStat->lpProcMsg  and get message return from UE side
			}
			break;
		default:
			{
				// To do your code
			
			}
			break;
	}
	delete l_pNotifyStatus;
	return 0;
}


CIFLSWD_SampleDlg::CIFLSWD_SampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CIFLSWD_SampleDlg::IDD, pParent)
	, m_strBlfFileName(_T(""))
	, m_strFBFFileName(_T(""))
	, m_DLType(eReadBLF)
	, m_strFlasherFile(_T(""))
	, m_bObmNotBoot(FALSE)
{
	//{{AFX_DATA_INIT(CIFLSWD_SampleDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_lPInstanceParams = NULL;
    m_gWTPhModule = NULL;
	m_gSWDhModule = NULL;
	m_bLoadBlf = false;
	m_bInitSWD = false;
	m_bInitBL = false;
	m_bTerminateBL = false;
	memset(m_szBlfFilename,0,BUF_SIZE);
	memset(m_szFBFFilename,0,BUF_SIZE);
}

void CIFLSWD_SampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIFLSWD_SampleDlg)
	DDX_Control(pDX, IDC_BUTTON_INITIALIZEBL, m_InitBLButton);
	DDX_Control(pDX, IDC_BUTTON_TERMINATE, m_TeminateButton);
	DDX_Control(pDX, IDC_BUTTON_LOADBLF, m_LoadBlfButton);
	DDX_Control(pDX, IDC_LIST_DOWNLOADSTATUS, m_DownloadStatusLst);
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_EDIT_BLF_FILE, m_strBlfFileName);
	DDX_Text(pDX, IDC_EDIT_FBF_FILE, m_strFBFFileName);
	DDX_Radio(pDX, IDC_RADIO_BLF, (int&)m_DLType);
	DDX_Text(pDX, IDC_EDIT_FLASHER_FILE, m_strFlasherFile);
	DDX_Control(pDX, IDC_EDIT_BADBLOCK, m_BadBlocksRate);
	DDX_Check(pDX, IDC_OBMNOTBOOT, m_bObmNotBoot);
}

BEGIN_MESSAGE_MAP(CIFLSWD_SampleDlg, CDialog)
	//{{AFX_MSG_MAP(CIFLSWD_SampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_LOADBLF, OnButtonInitSWDFile)
	ON_BN_CLICKED(IDC_BUTTON_INITIALIZEBL, OnButtonInitializeBL)
	ON_BN_CLICKED(IDC_BUTTON_TERMINATE, OnButtonTerminateDownload)
	ON_WM_CLOSE()
	ON_MESSAGE(WM_CALLBACK, OnCallbackFunc)
	//}}AFX_MSG_MAP
	
	ON_BN_CLICKED(IDC_BUTTON_BLF_BROWSE, &CIFLSWD_SampleDlg::OnBnClickedButtonBlfBrowse)
	ON_BN_CLICKED(IDC_BUTTON_FBF, &CIFLSWD_SampleDlg::OnBnClickedButtonFbf)
	ON_EN_CHANGE(IDC_EDIT_BLF_FILE, &CIFLSWD_SampleDlg::OnEnChangeEditBlfFile)
	ON_EN_CHANGE(IDC_EDIT_FBF_FILE, &CIFLSWD_SampleDlg::OnEnChangeEditFbfFile)
	ON_BN_CLICKED(IDC_RADIO_BLF, &CIFLSWD_SampleDlg::OnBnClickedRadioBlf)
	ON_BN_CLICKED(IDC_RADIO_FBF, &CIFLSWD_SampleDlg::OnBnClickedRadioFbf)
	ON_BN_CLICKED(IDC_RADIO_ZIP_DOWNLOAD,&CIFLSWD_SampleDlg::OnBtnClickedRadioZipDownload)
	ON_BN_CLICKED(IDC_BUTTON_FLASHER_BROWSE, &CIFLSWD_SampleDlg::OnBnClickedButtonFlasherBrowse)
	ON_EN_CHANGE(IDC_EDIT_FLASHER_FILE, &CIFLSWD_SampleDlg::OnEnChangeEditFlasherFile)
	ON_BN_CLICKED(IDC_RADIO_UPLOAD, &CIFLSWD_SampleDlg::OnBnClickedRadioUpload)
	ON_BN_CLICKED(IDC_RADIO_MAKE_ZIP_PACKGGE, &CIFLSWD_SampleDlg::OnBnClickedRadioMakeZipPackgge)
	ON_BN_CLICKED(IDC_OBMNOTBOOT, &CIFLSWD_SampleDlg::OnBnClickedObmnotboot)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIFLSWD_SampleDlg message handlers

BOOL CIFLSWD_SampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CImageList imgList;  /* 为ClistCtrl设置一个图像列表，以设置行高 */
	imgList.Create(IDB_BITMAP1, 48, 1, RGB(255, 255, 255)); /* IDB_BITMAP1 是 24*24的 所以行高24像素 */

	m_DownloadStatusLst.SetImageList(&imgList,LVSIL_SMALL);
    m_DownloadStatusLst.ModifyStyle(0,LVS_REPORT);

	m_DownloadStatusLst.SetExtendedStyle
		(m_DownloadStatusLst.GetExtendedStyle()| LVS_EX_GRIDLINES);

	m_DownloadStatusLst.InsertColumn(0, _T("Device"), LVCFMT_LEFT, 110);
	m_DownloadStatusLst.InsertColumn(1, _T("Socket Address"), LVCFMT_LEFT, 130);
	m_DownloadStatusLst.InsertColumn(2, _T("Process State"), LVCFMT_LEFT, 250);
	m_DownloadStatusLst.InsertColumn(3, _T("Progress"), LVCFMT_LEFT, 600);
	
	RefreshButtton();
	m_strBadRate = _T("10000");
	m_BadBlocksRate.SetWindowText(m_strBadRate);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIFLSWD_SampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == SC_CLOSE)
	{
	    
		::SendMessage(AfxGetMainWnd()->m_hWnd, WM_CLOSE, 0, 0);//Close window

	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CIFLSWD_SampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CIFLSWD_SampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CIFLSWD_SampleDlg::OnButtonInitSWDFile() 
{

	ResetAllParameters();

	BeginWaitCursor();
	
	if (m_gSWDhModule == NULL)
	{
		m_gSWDhModule = LoadLibrary(IFLSWDDLL_NAME);
	}
	
	if (m_gSWDhModule == NULL)
	{
		AfxMessageBox(_T("IFL_SWD.dll is not loaded!"));
		return;
	}
	if(!m_lPInstanceParams)
	{
		MALLOCINSTANCEPARAMS MallocInstanceParams = (MALLOCINSTANCEPARAMS)GetProcAddress(m_gSWDhModule, "MallocInstanceParams");
		m_lPInstanceParams = MallocInstanceParams();
	}
	
	if(!m_lPInstanceParams)
	{
		AfxMessageBox(_T("MallocInstanceParams FAILED"));
		return;
	}

	if(m_DLType == eFBF  ) // do FBF download
	{
		if(m_strFBFFileName.IsEmpty()||m_strBlfFileName.IsEmpty())
		{
			AfxMessageBox(_T("Please input FBF file and BLF File ,  they are empty"));
			return ;
		}
        
         PREPAREDOWNLOADWITHFBF PrepareDownloadWithFBF = (PREPAREDOWNLOADWITHFBF)GetProcAddress(m_gSWDhModule, "PrepareDownloadWithFBF");

		if(PrepareDownloadWithFBF(m_lPInstanceParams,m_szBlfFilename,m_szFlasherFileName,m_szFBFFilename))
		{
			m_bInitSWD = true;
		}
		else
		{
			m_bInitSWD = false ;
		}
	}
	else if(m_DLType== eReadBLF ) // Readblf to do download
	{
		if(m_strBlfFileName.IsEmpty())
		{
			AfxMessageBox(_T("Please input BLF file , it is empty"));
			return ;
		}

        READBLF ReadBLF = (READBLF)GetProcAddress(m_gSWDhModule, "ReadBLF");
		if(ReadBLF(m_lPInstanceParams,m_szBlfFilename))
		{
			m_bInitSWD = true;
		}
		else
		{
			m_bInitSWD = false ;
		}
	}
	else if( m_DLType==eUpload )
	{
		m_lPInstanceParams->DownloadMode = 1;//SingleDownload Mode
		if (m_bObmNotBoot)
		{
			m_lPInstanceParams->Commands |= (1 << 6);
		} else
		{
			m_lPInstanceParams->Commands &= !(1 << 6);
		}
		PREPAREUPLOAD PrepareUpload = (READBLF)GetProcAddress(m_gSWDhModule, "PrepareUpload");
		 if(PrepareUpload(m_lPInstanceParams,m_szUploadCfgname))
		 {
			 m_bInitSWD = true;
		 }
		 else
		 {
			 m_bInitSWD = false ;
		 }
	}
	else if (eMakeZipPackage == m_DLType)
	{
		if(m_strBlfFileName.IsEmpty())
		{
			AfxMessageBox(_T("Please input BLF file , it is empty"));
			return ;
		}	
		MAKEDOWNLOADPACKAGE pMakeDownloadPackage = (MAKEDOWNLOADPACKAGE)GetProcAddress(m_gSWDhModule,"MakeDownloadPackage");
	
		if(!pMakeDownloadPackage(m_szBlfFilename,_T("DownloadZipPackage.zip")))
		{
			MessageBox(_T("Make download package failed."));
			return;
		}	
		else
		{
			MessageBox(_T("Make download package success."));
		}
	}
	else if (eZipDonwload == m_DLType)
	{
		if(m_strZipPackageName.IsEmpty())
		{
			AfxMessageBox(_T("Please input download package, it is empty"));
			return ;
		}


		DOWNLOADWPACKAGE pDownloadWithPackage = (DOWNLOADWPACKAGE)GetProcAddress(m_gSWDhModule,"DownloadWithPackage");
		if(!pDownloadWithPackage(m_szZipPackageName,m_lPInstanceParams))
		{
			MessageBox(_T("Parse Zip download package failed."));
			m_bInitSWD = false ;
			return;
		}
		else
		{
			m_bInitSWD = true;
		}
	}
	
	EndWaitCursor();
	RefreshButtton();
}
 

void CIFLSWD_SampleDlg::OnButtonInitializeBL() // Initialize WTPTP to enter download
{
	if(!m_bInitSWD)
	{
		AfxMessageBox(_T("Please wait for all files in Temp are ready"));
		return; // please wait all temp file are ready
	}
	

	CALLBACKPROC l_pfncCallBack;
	
	l_pfncCallBack = CallbackProc;
	
	m_lPInstanceParams->CallbackProc = l_pfncCallBack;
	m_lPInstanceParams->UserData = (LPVOID)this;
	m_BadBlocksRate.GetWindowText(m_strBadRate);
	m_lPInstanceParams->ReservedVal[0] = _ttoi(m_strBadRate);
	if (m_gWTPhModule == NULL)
	{
		m_gWTPhModule = LoadLibrary(WTPTPDOWNLOADDLL_NAME);
	}
	
	if (m_gWTPhModule == NULL)
	{
		AfxMessageBox(_T("WtptpDownLoad.dll is not loaded!"));
		return;
	}

    INITIALIZEBL  InitializeBL = (INITIALIZEBL)GetProcAddress(m_gWTPhModule, "InitializeBL");
	if (InitializeBL(m_lPInstanceParams) == TRUE)
	{
		m_bInitBL = true;
		m_TeminateButton.EnableWindow(m_bInitBL);
		m_InitBLButton.EnableWindow(false);
		m_LoadBlfButton.EnableWindow(false);
	}
	else
		AfxMessageBox(_T("InitializeBL failed"));

	RefreshButtton();
}


BOOL CIFLSWD_SampleDlg::AddDevice(NotifyStatus* pNtStat)
{
    BOOL bSuccess = false;
	CListProgress* pListProgr = NULL;
	
	if (!m_ProgressMap.Lookup(pNtStat->lpUSBPortAddress, (void*&)pListProgr))
	{
		int nItem = m_DownloadStatusLst.GetItemCount();
		CString text, address = pNtStat->lpUSBPortAddress;

		text.Format(_T("%s %d"),DEVICE_USB_PORT,pNtStat->nDevice);

		m_DownloadStatusLst.InsertItem(nItem, text); 
		m_DownloadStatusLst.SetItemText(nItem, 1, address);
		m_DownloadStatusLst.SetItemText(nItem, 2, aProcStateMsgTable[kProcIdle].szStateMsg);
		CreateProgress(pNtStat->lpUSBPortAddress, nItem);
	}
	
	return bSuccess;
}

BOOL CIFLSWD_SampleDlg::CreateProgress(LPCTSTR lpUsbAddress, int nItem)
{
  BOOL bSuccess = false;
  CListProgress* pListProgr = new CListProgress(nItem);

  
  CRect ItemRect;
  m_DownloadStatusLst.GetSubItemRect(nItem, 3, LVIR_BOUNDS, ItemRect);

  ItemRect.DeflateRect(1,1);

   bSuccess = pListProgr->Create(PBS_SMOOTH | WS_CHILD | WS_VISIBLE, 
								   CRect(ItemRect.left, ItemRect.top, ItemRect.right, ItemRect.bottom), 
								   &m_DownloadStatusLst, 
								   ID_PROGRESS_CTRL);
   if (bSuccess)
   {
	   pListProgr->ModifyStyleEx(0, SWP_NOZORDER);
	   pListProgr->SetShowText(true);
	   pListProgr->SetRange(0, 100);
	   pListProgr->SetPos(0);
	   m_DownloadStatusLst.SetItemData(nItem, (DWORD)pListProgr);
	   m_ProgressMap[lpUsbAddress] = pListProgr;
   }
   return bSuccess;
}

BOOL CIFLSWD_SampleDlg::SetProcState(NotifyStatus* l_pNotifyStatus)
{

    BOOL bSuccess = false;
	CString strDescrption;
	CString msg(aProcStateMsgTable[l_pNotifyStatus->eProcState].szStateMsg);
	strDescrption.Format(_T("proc message: %s,%s"), msg,l_pNotifyStatus->lpProcMsg);
	CListProgress* pListProgr = NULL;
	if (l_pNotifyStatus->lpUSBPortAddress && m_ProgressMap.Lookup(l_pNotifyStatus->lpUSBPortAddress, (void*&)pListProgr))
	{
		if (pListProgr && IsWindow(pListProgr->m_hWnd))
		{
			int nItem = pListProgr->GetIndex();
			if (!strDescrption.IsEmpty())
			{  
				m_DownloadStatusLst.SetItemText(nItem, 2, strDescrption);
			}
			bSuccess = true;
		}
	}
	return bSuccess;

}


BOOL CIFLSWD_SampleDlg::SetProgress(NotifyStatus* pNtStat)
{
	BOOL bSuccess = false;
	CListProgress* pListProgr = NULL;
	CString percent;
    CString strMsg(aProcStateMsgTable[pNtStat->eProcState].szStateMsg);
	percent.Format(_T("%s:%d%%"), strMsg,pNtStat->nDownloadedPercent);

	if (m_ProgressMap.Lookup(pNtStat->lpUSBPortAddress, (void*&)pListProgr))
	{
		if (pNtStat->nDownloadedPercent == 0)
		{		   
			pListProgr->SetShowText(true);
		}
		pListProgr->SetPos(pNtStat->nDownloadedPercent);
		pListProgr->SetWindowText(percent);

		bSuccess = true;
	}
	return bSuccess;
}

BOOL CIFLSWD_SampleDlg::RemoveAllDevices()
{
    CListProgress* pListProgress = NULL;
	m_iSWDDeviceNumber = 0;
	CString lpUsbAddress;
	for (POSITION pos = m_ProgressMap.GetStartPosition(); pos != NULL; )
	{
		m_ProgressMap.GetNextAssoc(pos, lpUsbAddress, (void*&)pListProgress);
	
		if (pListProgress && IsWindow(pListProgress->m_hWnd))
		{
			pListProgress->DestroyWindow();
			delete pListProgress;
		}
	}
	m_ProgressMap.RemoveAll();

	if (m_DownloadStatusLst.GetItemCount())
	{
		while(m_DownloadStatusLst.DeleteItem(0))
			continue;
	}
	
	return true;
}
BOOL CIFLSWD_SampleDlg::RemoveDevice(LPCTSTR lpUsbAddress, BOOL bRemoveByNow)
{
	int nSize, nItemIdx;
	CString UsbAddress;
	--m_iSWDDeviceNumber;
	CListProgress* pListProgress = NULL;

	if (lpUsbAddress && m_ProgressMap.Lookup(lpUsbAddress, (void*&)pListProgress))
	{
		if (pListProgress)
		{
					pListProgress->DestroyWindow();
					delete pListProgress;
			
		}
	}
	return true;
}


 LRESULT CIFLSWD_SampleDlg::OnProgressToView(LPARAM lParam)
 {
	NotifyStatus* pNtStat = (NotifyStatus*)lParam;
	eProcessStatus		m_CurPrcStatus  = pNtStat->eProcStatus;
	SetProgress(pNtStat);
	return 0;
 }


 // please Terminate WTPTP to stop all download procedure


void CIFLSWD_SampleDlg::OnButtonTerminateDownload() 
{
    m_bTerminateBL = true;
	m_bInitSWD = false;
	m_bInitBL= false;
	if(!StopDownload())
	{
		AfxMessageBox(_T("Can't Teminate Download"));
	}
	RefreshButtton();
	if(m_lPInstanceParams)
	{
		FREEINSTANCEPARAMS FreeInstanceParams = (FREEINSTANCEPARAMS)GetProcAddress(m_gSWDhModule, "FreeInstanceParams");
		FreeInstanceParams(m_lPInstanceParams);
		m_lPInstanceParams = NULL;
	}
}


void CIFLSWD_SampleDlg::OnClose() 
{
	StopDownload();
	CDialog::OnClose();	

	if (m_gWTPhModule != NULL)
	{
		FreeLibrary(m_gWTPhModule);
	}

	if (m_gSWDhModule != NULL)
	{
		FreeLibrary(m_gSWDhModule);
	}
}

BOOL CIFLSWD_SampleDlg::StopDownload()
{
	
	if (m_gWTPhModule == NULL)
	{
		m_gWTPhModule = LoadLibrary(WTPTPDOWNLOADDLL_NAME);
	}

	if (m_gWTPhModule == NULL)
	{
		AfxMessageBox(_T("IFL_SWD.dll is not loaded!"));
		return false;
	}

	TERMINATEBL TerminateBL = (TERMINATEBL)GetProcAddress(m_gWTPhModule, (LPCSTR) ("TerminateBL"));	
	
    if(!TerminateBL)
	{
		AfxMessageBox(_T("GetProcAddress for TerminateBL failed!"));
		return false;
	}
	if(!TerminateBL())
			return false;
		else
		{
			m_bTerminateBL = true;
			m_LoadBlfButton.EnableWindow(true);
		    m_TeminateButton.EnableWindow(false);
			m_InitBLButton.EnableWindow(true);
		}

	RemoveAllDevices();
    RefreshButtton();
	return true;
}

void CIFLSWD_SampleDlg::ResetAllParameters()
{
	
	m_bLoadBlf = false;
	m_bInitSWD = false;
	m_bInitBL = false;
	m_iEnableItems = 0;
    StopDownload();
	m_TeminateButton.EnableWindow(m_bInitBL);
	m_InitBLButton.EnableWindow(m_bInitSWD);
   
	
}


void CIFLSWD_SampleDlg::RefreshButtton()
{
	m_InitBLButton.EnableWindow(m_bInitSWD&&!m_bInitBL);
	m_TeminateButton.EnableWindow(m_bInitBL);	
	//m_LoadBlfButton.EnableWindow(!m_bTerminateBL&&!m_bInitBL&&!m_bInitSWD);
	if(eFBF==m_DLType)
	{
		GetDlgItem(IDC_STATIC_FLASHER)->ShowWindow(true);
		GetDlgItem(IDC_STATIC_FBF)->ShowWindow(true);
		GetDlgItem(IDC_EDIT_FLASHER_FILE)->ShowWindow(true);
		GetDlgItem(IDC_EDIT_FBF_FILE)->ShowWindow(true);
		GetDlgItem(IDC_BUTTON_FBF)->ShowWindow(true);
		GetDlgItem(IDC_BUTTON_FLASHER_BROWSE)->ShowWindow(true);
		GetDlgItem(IDC_OBMNOTBOOT)->ShowWindow(false);
		SetDlgItemText(IDC_BUTTON_LOADBLF,_T("InitSWDFile"));
		SetDlgItemText(IDC_STATIC_BLF,_T("BLF File"));
		
	}
	else if(eReadBLF==m_DLType)
	{
		GetDlgItem(IDC_OBMNOTBOOT)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FLASHER)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FBF)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FLASHER_FILE)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FBF_FILE)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FBF)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FLASHER_BROWSE)->ShowWindow(false);
		SetDlgItemText(IDC_BUTTON_LOADBLF,_T("InitSWDFile"));
		SetDlgItemText(IDC_STATIC_BLF,_T("BLF File"));
	}
	else if(eUpload == m_DLType)
	{
		GetDlgItem(IDC_OBMNOTBOOT)->ShowWindow(true);
		GetDlgItem(IDC_STATIC_FLASHER)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FBF)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FLASHER_FILE)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FBF_FILE)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FBF)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FLASHER_BROWSE)->ShowWindow(false);
		SetDlgItemText(IDC_BUTTON_LOADBLF,_T("DoUpload"));
		SetDlgItemText(IDC_STATIC_BLF,_T("UploadCfgFile"));
		UpdateData(false);
	}
	else if (eMakeZipPackage == m_DLType)
	{
		GetDlgItem(IDC_OBMNOTBOOT)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FLASHER)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FBF)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FLASHER_FILE)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FBF_FILE)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FBF)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FLASHER_BROWSE)->ShowWindow(false);
		SetDlgItemText(IDC_BUTTON_LOADBLF,_T("GeneratePackage"));
		SetDlgItemText(IDC_STATIC_BLF,_T("BLF File"));
		m_InitBLButton.EnableWindow(false);
		m_TeminateButton.EnableWindow(false);	
	}
	else if (eZipDonwload == m_DLType)
	{
		GetDlgItem(IDC_OBMNOTBOOT)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FLASHER)->ShowWindow(false);
		GetDlgItem(IDC_STATIC_FBF)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FLASHER_FILE)->ShowWindow(false);
		GetDlgItem(IDC_EDIT_FBF_FILE)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FBF)->ShowWindow(false);
		GetDlgItem(IDC_BUTTON_FLASHER_BROWSE)->ShowWindow(false);
		SetDlgItemText(IDC_BUTTON_LOADBLF,_T("DownloadPackage"));
		SetDlgItemText(IDC_STATIC_BLF,_T("Zip Package"));
	}
	

}


void CIFLSWD_SampleDlg::OnBnClickedButtonBlfBrowse()
{
	static TCHAR BASED_CODE szFilter[] = _T("BLF Files (*.blf)|*.blf|");
	static TCHAR BASED_CODE szTXTFilter[] = _T("Text File (*.txt)|*.txt|");
	static TCHAR BASED_CODE szZipFilter[] = _T("Zip File (*.zip)|*.zip|Rar File (*.rar)|*.rar|");
	if(eReadBLF == m_DLType || eMakeZipPackage == m_DLType)
	{
		CFileDialog		dlgFilePathName(TRUE, NULL, m_strBlfFileName, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);
		if(dlgFilePathName.DoModal()== IDOK)
		{
			m_strBlfFileName = dlgFilePathName.GetPathName();
		} //Add image information in view and let user edit
		_tcscpy(m_szBlfFilename,m_strBlfFileName.GetBuffer(m_strBlfFileName.GetLength()));
		m_strBlfFileName.ReleaseBuffer();  
	}

	if(eZipDonwload == m_DLType)
	{
		CFileDialog		dlgFilePathName(TRUE, NULL, m_strZipPackageName, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szZipFilter);
		if(dlgFilePathName.DoModal()== IDOK)
		{
			m_strZipPackageName = dlgFilePathName.GetPathName();
		} //Add image information in view and let user edit
		_tcscpy(m_szZipPackageName,m_strZipPackageName.GetBuffer(m_strZipPackageName.GetLength()));
		m_strZipPackageName.ReleaseBuffer(); 
		m_strBlfFileName = m_strZipPackageName;
	}

	if(eUpload == m_DLType)
	{
		CFileDialog		dlgFilePathName(TRUE, NULL, m_strUploadCfgFile, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szTXTFilter);
		if(dlgFilePathName.DoModal()== IDOK)
		{
			m_strUploadCfgFile = dlgFilePathName.GetPathName();
		} 
		_tcscpy(m_szUploadCfgname,m_strUploadCfgFile.GetBuffer(m_strUploadCfgFile.GetLength()));
		m_strUploadCfgFile.ReleaseBuffer();  
		m_strBlfFileName = m_strUploadCfgFile;
	}
	

	//Add image information in view and let user edit
	UpdateData(false);
}

void CIFLSWD_SampleDlg::OnBnClickedButtonFbf()
{
	static TCHAR BASED_CODE szFBFFilter[] = _T("FBF Files (*.bin)|*.bin|");
	CFileDialog		dlgFilePathName(TRUE, NULL, m_strFBFFileName, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFBFFilter);
	if(dlgFilePathName.DoModal()== IDOK)
	{
		char buffer[BUF_SIZE];
		m_strFBFFileName = dlgFilePathName.GetPathName();
	} 
	//Add image information in view and let user edit
	_tcscpy(m_szFBFFilename,m_strFBFFileName.GetBuffer(m_strFBFFileName.GetLength()));
	m_strFBFFileName.ReleaseBuffer(); 
	UpdateData(false);
}

void CIFLSWD_SampleDlg::OnEnChangeEditBlfFile()
{
	UpdateData(true);
}

void CIFLSWD_SampleDlg::OnEnChangeEditFbfFile()
{
	UpdateData(true);
}

void CIFLSWD_SampleDlg::OnBnClickedRadioBlf()
{
	m_DLType = eReadBLF;
	UpdateData(false);
	RefreshButtton();
}

void CIFLSWD_SampleDlg::OnBtnClickedRadioZipDownload()
{
	m_DLType = eZipDonwload;
	UpdateData(false);
	SetDlgItemText(IDC_EDIT_BLF_FILE,_T(""));
	RefreshButtton();
}

void CIFLSWD_SampleDlg::OnBnClickedRadioFbf()
{
	m_DLType = eFBF;
	UpdateData(false);
	RefreshButtton();
}

void CIFLSWD_SampleDlg::OnBnClickedRadioMakeZipPackgge()
{
	m_DLType = eMakeZipPackage;
	UpdateData(false);	
	RefreshButtton();
}


void CIFLSWD_SampleDlg::OnBnClickedButtonFlasherBrowse()
{
	static TCHAR BASED_CODE szFLASHERFilter[] = _T("Flasher Files (*.bin)|*.bin|");
	CFileDialog		dlgFilePathName(TRUE, NULL, m_strFlasherFile, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFLASHERFilter);
	if(dlgFilePathName.DoModal()== IDOK)
	{
		char buffer[BUF_SIZE];
		m_strFlasherFile = dlgFilePathName.GetPathName();
	} 
	//Add image information in view and let user edit
	_tcscpy(m_szFlasherFileName,m_strFlasherFile.GetBuffer(m_strFlasherFile.GetLength()));
	m_strFlasherFile.ReleaseBuffer(); 
	UpdateData(false);
}

void CIFLSWD_SampleDlg::OnEnChangeEditFlasherFile()
{
	UpdateData(true);
}

void CIFLSWD_SampleDlg::OnBnClickedRadioUpload()
{
	m_DLType = eUpload;
	UpdateData(false);
	RefreshButtton();
}



void CIFLSWD_SampleDlg::OnBnClickedObmnotboot()
{
	if (!m_bInitSWD)
	{
		AfxMessageBox(_T("Please ReadBLF First"));
		((CButton*)GetDlgItem(IDC_OBMNOTBOOT))->SetCheck(0);
		return;
	}
	UpdateData(TRUE);
}
