// BLFDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BLFDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBLFDlg dialog


CBLFDlg::CBLFDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBLFDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBLFDlg)
	m_sBlfPath = _T("");
	m_sFBFFile = _T("");
	m_sFlasherFilePath = _T("");
	m_sFlashINIPath = _T("");
	//}}AFX_DATA_INIT
}


void CBLFDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBLFDlg)
	DDX_Text(pDX, IDC_BLF_EDIT, m_sBlfPath);
	DDX_Text(pDX, IDC_FBF_FILE_EDIT, m_sFBFFile);
	DDX_Text(pDX, IDC_FLASHER_FILE_EDIT, m_sFlasherFilePath);
	DDX_Text(pDX, IDC_FLASH_INI_EDIT, m_sFlashINIPath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBLFDlg, CDialog)
	//{{AFX_MSG_MAP(CBLFDlg)
	ON_BN_CLICKED(IDC_BLF_BUTTON, OnBlfBrowseButton)
	ON_EN_CHANGE(IDC_BLF_EDIT, OnChangeBlfPathEdit)
	ON_BN_CLICKED(IDC_OK, OnOk)
	ON_EN_CHANGE(IDC_FBF_FILE_EDIT, OnChangeFbfFileEdit)
	ON_EN_CHANGE(IDC_FLASHER_FILE_EDIT, OnChangeFlasherFileEdit)
	ON_EN_CHANGE(IDC_FLASH_INI_EDIT, OnChangeFlashIniEdit)
	ON_BN_CLICKED(IDC_FBF_FILE_BUTTON, OnFbfFileButton)
	ON_BN_CLICKED(IDC_FLASHER_FILE_BUTTON, OnFlasherFileButton)
	ON_BN_CLICKED(IDC_CANCEL, OnCancel)
	ON_BN_CLICKED(IDC_FLASH_INI_BUTTON, OnFlashIniButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBLFDlg message handlers

void CBLFDlg::OnBlfBrowseButton() 
{
   UpdateData();


	CFileDialog dlg (	TRUE, 
						NULL,
						NULL,
						OFN_HIDEREADONLY | OFN_EXPLORER, 
						_T("Blf Files(*.BLF)|*.BLF|")
						,
						this
					);

	if(dlg.DoModal() == IDOK)
	{
		m_sBlfPath = dlg.GetPathName();
		
		UpdateData(0);
	}			
	
}

void CBLFDlg::OnChangeBlfPathEdit() 
{
	UpdateData(TRUE);
	
}

void CBLFDlg::OnOk() 
{
	UpdateData();
	CDialog::OnOK();
	
}

void CBLFDlg::OnCancel() 
{
	CDialog::OnCancel();
	
}

void CBLFDlg::OnChangeFbfFileEdit() 
{
    UpdateData(TRUE);
	
}

void CBLFDlg::OnChangeFlasherFileEdit() 
{
   UpdateData(TRUE);
	
}

void CBLFDlg::OnChangeFlashIniEdit() 
{
	UpdateData(TRUE);
	
}

void CBLFDlg::OnFbfFileButton() 
{
	UpdateData(false);

	CFileDialog dlg (	TRUE, 
		NULL,
		NULL,
		OFN_HIDEREADONLY | OFN_EXPLORER, 
		_T("fbf Files(*.bin)|*.bin| All Files (*.*)|*.*|"),
		this
		);
	
	if(dlg.DoModal() == IDOK)
	{
		m_sFBFFile = dlg.GetPathName();
		
		UpdateData(0);
	}			
	
}

void CBLFDlg::OnFlasherFileButton() 
{
	UpdateData();

	CFileDialog dlg (TRUE, 
		NULL,
		NULL,
		OFN_HIDEREADONLY | OFN_EXPLORER, 
		_T("Flahser bin Files(*.bin)|*.bin| All Files (*.*)|*.*|"),
		this
		);
	
	if(dlg.DoModal() == IDOK)
	{
		m_sFlasherFilePath = dlg.GetPathName();
		
		UpdateData(0);
	}			
	
	
}

void CBLFDlg::OnFlashIniButton() 
{
	UpdateData(false);

	CFileDialog dlg (	TRUE, 
		NULL,
		NULL,
		OFN_HIDEREADONLY | OFN_EXPLORER, 
		_T("Flash INI Files(*.ini)|*.ini| All Files (*.*)|*.*|"),
		this
		);
	
	if(dlg.DoModal() == IDOK)
	{
		m_sFlashINIPath = dlg.GetPathName();
		
		UpdateData(0);
	}			
	
}
