#pragma once

#include "ParaDefine.h"


/*******************************************************************************************************************

 (C) Copyright  Marvell Semiconductor Hefei branch Ltd. All Rights Reserved  

 *******************************************************************************************************************/

#ifdef WTPTPDOWNLOAD_DYNAMIC
#ifdef WTPTPDOWNLOAD_EXPORTS
#define WTPTPDOWNLOAD_FUNC    extern "C"  __declspec(dllexport)
#else
#define WTPTPDOWNLOAD_FUNC    extern "C" __declspec(dllimport)
#endif
#else
#define WTPTPDOWNLOAD_FUNC
#endif

/*! @defgroup group Functions list
* @{
*/
/// =========================================
/// @fn			InitializeBL(PInstanceParams pInstParam)
/// @brief		This function is used to initialize download parameter and waiting for USB device arrived
/// @param[in]	PInstParam including download file list and DKB files name and other configurations.                                                                 
/// @return		bool.
///				@retval true : Successfully .  
///				@retval false : Failed .
/// @note		please input the parameter of  pInstParam from IFL_SWD function output \n
///
/// =========================================
WTPTPDOWNLOAD_FUNC BOOL  InitializeBL(PInstanceParams pInstParam);

/// =========================================
/// @fn			TerminateBL()
/// @brief		Terminate download process                                                                    
/// @return		bool.
///				@retval true : Successfully .  
///				@retval false : Failed .
/// @note		This function is used to stop all download process \n
///
/// =========================================
WTPTPDOWNLOAD_FUNC BOOL  TerminateBL();

/// =========================================
/// @fn			SetWtptpLogPath()
/// @brief		Set customized path for log output instead of application path
/// @return		bool.
///				@retval true : Successfully .  
///				@retval false : Failed .
///
/// =========================================
WTPTPDOWNLOAD_FUNC BOOL  SetWtptpLogPath(const TCHAR *pszLogPath);
///@}		//@defgroup group Functions list


/// =========================================
/// @fn			SetUSBPhyAddrEnable(tstring UsbDevName, BOOL bEnable)
/// @brief		This function enable/disable detect certain USB physical address to download.And the initial state is Enable to detect.                                          
/// @return		bool.
///				@retval true : Successfully .  
///				@retval false : Failed .
/// @note		If SWD never detect input UsbDevName(Physical Address), function would rentun FALSE.
///
/// =========================================
WTPTPDOWNLOAD_FUNC BOOL SetUSBPhyAddrEnable(LPCTSTR UsbDevName, BOOL bEnable);